; ----------------------------------------------------------
; RS232control
; ----------------------------------------------------------

; w13 und w12 fr diverses innerhalb einer Aktion reserviert 

.include "allgdef.inc"
 
.global	RS232control

RS232control:
; Sprung laut (D)rs232csta
	mov		rs232csta,w0
	bra		w0
	bra		rs232c0
	bra		rs232c1
	bra		rs232c2
	bra		rs232c3
	bra		rs232c4
	bra		rs232c5
	bra		rs232c6
	bra		rs232c7
	bra		rs232c8
	bra		rs232c9
	bra		rs232c10
	bra		rs232c11
	bra		rs232c12
	bra		rs232c13
	bra		rs232c14

; ---------------------------------------------------------
; Kommando > erforderlichen Zeiger fr rs232csta holen
; ---------------------------------------------------------

rs232c0:
	bset	LATC,#15
	call	Holers232adresse		; in W7, danach ++
	cp0		w7
	bra		z,rs232ctimset

	mov.b	[w7],w0
	clr.b	[w7]
	sub.b	#65,w0					;'A'
	bra		nc,rs232creset				;unter A
	mov		#26,w1
	cp.b	w0,w1
	bra		ge,rs232creset				; ber Z
	ze		w0,w0
	mov		#psvoffset(Kommandotabelle),w7
	add		w0,w7,w7
	mov.b	[w7],w0
	cp0.b	w0
	bra		z,rs232creset			; falsches Kommando	
	mov		w0,rs232csta
	bclr	LATC,#15
	clr		w13						 ; Byte zlr
	return

; -----------------------------------
; Reserve
; -----------------------------------
rs232c1:
	mov		fontbreite,w0
	mov		#12,w1
	cp		w1,w0
	bra		z,rs232c1a
	mov		#16,w1
	cp		w1,w0
	bra		z,rs232c1a
	mov		#24,w1
	cp		w1,w0
	bra		z,rs232c1a
	mov		#32,w1
	cp		w1,w0
	bra		z,rs232c1a
	call	Holefont1
rs232c1a:
	inc		rs232csta
	return
		
; -----------------------------------
; Kommando C = TFT Lschen  ("C&")
; -----------------------------------
rs232c2:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset				; Fehler: & fehlt
	call	Tftclr					; bleibt darin bis Fertig
	bra		rs232creset

; -----------------------------------
; Kommando F = Font 1 bis 4 setzen ("F4&")
; -----------------------------------
rs232c3:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13					; 1. Zeichen (Ziffer)?
	bra		nz,rs232c3a
	mov		w0,w12				; sichern
	inc		w13,w13
	return
rs232c3a:
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset		; Fehler: & fehlt
	and		#0b00000111,w12
	bra		z,rs232creset		; 0 nicht erlaubt
	cp		w12,#5
	bra		ge,rs232creset
	bra		w12
	bra		rs232c3f1
	bra		rs232c3f1
	bra		rs232c3f2
	bra		rs232c3f3
	bra		rs232c3f4
rs232c3f1:
	call	Holefont1
	bra		rs232creset
rs232c3f2:
	call	Holefont2
	bra		rs232creset
rs232c3f3:
	call	Holefont3
	bra		rs232creset
rs232c3f4:
	call	Holefont4
	bra		rs232creset
		
; -----------------------------------
; Kommando H = Farbe, Hintergrund 0 bis 8  ("H8&")
; -----------------------------------
rs232c4:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c4a
	mov		w0,w12
	inc		w13,w13
	return
rs232c4a:
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset		; Fehler: & fehlt
	and		#0b00001111,w12
	cp		w12,#9				; 0...8 erlaubt
	bra		ge,rs232creset		; nur bis 8 erlaubt
	call	Holefarbe				; w12 > w0
	mov		w0, hintergrund
	bra		rs232creset
	
; -----------------------------------
; Kommando I = TFT-typ ("I0&")
; -----------------------------------
rs232c5:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c5a
	mov		w0,w12
	inc		w13,w13
	return
rs232c5a:
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset		; Fehler: & fehlt
	bset	merker,#tftrevers
	btss	w12,#0
	bclr	merker,#tftrevers
	bra		rs232creset

; -----------------------------------
; Kommando L= Linie bzw Rechteck ("L123123&")
; -----------------------------------
rs232c6:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c6a
	mov		#linienpuffer,w7
	mov		w7,linienadr
rs232c6a:
	inc		w13,w13
	cp		w13,#7					; alle Daten drin?
	bra		nz,rs232c6b				; nein
	mov		#0x26,w1				; ja, & ? 
	cp.b	w1,w0
	bra		nz,rs232creset			; & fehlt
	bra		rs232c6c
rs232c6b:
	call	Ziffertest				; w0 >> z
	bra		z,rs232creset
	mov		linienadr,w7
	mov		w0,[w7++]
	mov		w7,linienadr
	return
rs232c6c:
	mov		#linienpuffer,w7
	mov		w7,linienadr
	call	Zeichnelinie			; Parameter erzeugen
	mov		#14,w0
	mov		w0,rs232csta
	return

; -----------------------------------
; Kommando R = Char in Zeile nach Rechts versetzen ("R9&")
; -----------------------------------
rs232c7:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c7a
	mov		w0,w12
	inc		w13,w13
	return
rs232c7a:
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset		; Fehler: & fehlt
	and		#0b00001111,w12
	cp		w12,#10
	bra		ge,rs232creset		; nur bis 9 erlaubt
	mov		w12,nachrechts
	bra		rs232creset
	
; -----------------------------------
; Kommando T = Textstring in Ascii zum TFT  ("TTEXT...&")
; -----------------------------------
rs232c8:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		z,rs232c8b
	cp0		w13
	bra		nz,rs232c8a
	mov		#lcdpuffer,w7
	mov		w7,lcdzgr
rs232c8a:
	mov		lcdzgr,w7
	ze		w0,w0	
	mov		w0,[w7++]
	mov		w7,lcdzgr
	inc		w13,w13
	mov		#lcdmaximal,w12
	cp		w12,w13
	bra		lt,rs232creset		; Fehler: berlauf
	return
rs232c8b:
	mov		lcdzgr,w7
	clr		 [w7]				; ende-zeichen
	mov		#lcdpuffer,w7
	mov		w7,lcdzgr
	bset	merker,#lcdaktiv
	call	Ydrehen
	mov		#14,w0
	mov		w0,rs232csta
	return
	 
; -----------------------------------
; Kommando U = Char in Zeile nach Unten versetzen  ("U9&")
; -----------------------------------
rs232c9:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c9a
	mov		w0,w12
	inc		w13,w13
	return
rs232c9a:
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset		; Fehler: & fehlt
	and		#0b00001111,w12
	cp		w12,#10
	bra		ge,rs232creset		; nur bis 10 erlaubt
	mov		w12,nachunten
	bra		rs232creset

; -----------------------------------
; Kommando X = X-Position, 3 Dez-Ziffern  ("X123&")
; -----------------------------------
rs232c10:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c10a
	mov		#pospuffer,w7
	mov		w7,posadr
rs232c10a:
	inc		w13,w13
	cp		w13,#4					; alle Daten drin?
	bra		nz,rs232c10b			; nein
	mov		#0x26,w1				; ja, & ? 
	cp.b	w1,w0
	bra		nz,rs232creset			; & fehlt
	bra		rs232c10c
rs232c10b:
	call	Ziffertest				; w0 >> z
	bra		z,rs232creset
	mov		posadr,w7
	mov		w0,[w7++]
	mov		w7,posadr
	return
rs232c10c:
	mov		#pospuffer,w7
	mov		w7,posadr
	call	Holepos					; (D)pospuffer > w1
	mov		w1,xpos
	bra		rs232creset
	
; -----------------------------------
; Kommando Y = Y-Position  ("Y123&")
; -----------------------------------
rs232c11:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c11a
	mov		#pospuffer,w7
	mov		w7,posadr
rs232c11a:
	inc		w13,w13
	cp		w13,#4					; alle Daten drin?
	bra		nz,rs232c11b			; nein
	mov		#0x26,w1				; ja, & ? 
	cp.b	w1,w0
	bra		nz,rs232creset			; & fehlt
	bra		rs232c11c
rs232c11b:
	call	Ziffertest				; w0 >> z
	bra		z,rs232creset
	mov		posadr,w7
	mov		w0,[w7++]
	mov		w7,posadr
	return
rs232c11c:
	mov		#pospuffer,w7
	mov		w7,posadr
	call	Holepos					; (D)pospuffer > w1
	mov		w1,rsypos
	bra		rs232creset

; -----------------------------------
; Kommando Z = Farbe, Schrift  ("Z3&")
; -----------------------------------
rs232c12:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	cp0		w13
	bra		nz,rs232c12a
	mov		w0,w12
	inc		w13,w13
	return
rs232c12a:
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset			; Fehler: &  fehlt
	and		#0b00001111,w12
	cp		w12,#9
	bra		ge,rs232creset			; nur bis 8 erlaubt
	call	Holefarbe				; w12 > w0
	mov		w0,schriftfarbe
	bra		rs232creset

; -----------------------------------
; Kommando A = bitte ein Echo  ("A&") >> ("a")
; -----------------------------------
rs232c13:
	call	Holers232adresse
	cp0		w7
	bra		z,rs232ctimout
	mov.b	[w7],w0
	clr.b	[w7]
	mov		#0x26,w1				; &
	cp.b	w1,w0
	bra		nz,rs232creset				; Fehler: &  fehlt
	call	Rs232csnd				; bleibt darin bis Fertig
	bra		rs232creset

; -----------------------------------
; Kommando T bzw L = 2.Teil, Warten bis TFT fertig ist
; -----------------------------------
rs232c14:
	btss	merker,#lcdaktiv
	bra		rs232creset
	return

; ******************** Ausgnge  ****************

; Zeit abgelaufen?
rs232ctimout:
	disi	#1
	cp0		rs232ctimer
	bra		z, rs232creset
	return
rs232ctimset:
	disi	#2
	mov		#400,w0
	mov		w0,rs232ctimer
	return	
; RS232 reset, Aus schalten
rs232creset:
	disi	#2
	mov		#400,w0			; 4 Sek Timout
	mov		w0,rs232ctimer
	nop
	mov		#pospuffer,w0
	mov		w0,posadr
	clr		w12
	clr		w13
	clr		rs232csta
	return
	
; -------------------------------------------------
; RS232 Sender starten fr nur 1 Char
; -------------------------------------------------
; Aktiviert wenn (B)pcbsndanf=1
; Eingang: nur "a"

Rs232csnd:
; Sender Frei?
	btsc	U1STA,#9
	bra		Rs232csnd
	mov		#'a',w0
	mov		w0,U1TXREG
	return			

	
